using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Android.App;
using Android.Content;
using Android.OS;
using Android.Runtime;
using Android.Views;
using Android.Widget;

namespace iXTankenAndroid
{
   

    class AddNewMyAdapter
    {
        private AddActivity MyActivity;
        private AddNewViewModel ViewModel;

        private EditText Datum;
        private EditText Kilometerstand;
        private EditText Menge;
        private EditText Betrag;
        private EditText Anmerkung;

        public AddNewMyAdapter(AddActivity activity, AddNewViewModel viewModel)
        {
            this.MyActivity = activity;
            this.ViewModel = viewModel;

            Datum = MyActivity.FindViewById<EditText>(Resource.Id.add_datum);
            Kilometerstand = MyActivity.FindViewById<EditText>(Resource.Id.add_kilometerstand);
            Menge = MyActivity.FindViewById<EditText>(Resource.Id.add_menge);
            Betrag = MyActivity.FindViewById<EditText>(Resource.Id.add_betrag);
            Anmerkung = MyActivity.FindViewById<EditText>(Resource.Id.add_anmerkung);

            GetDataFromViewModel();
        }

        public void GetDataFromViewModel()
        {
            Datum.Text = ViewModel.Datum.ToShortTimeString();
            Kilometerstand.Text = ViewModel.Kilometerstand.ToString();
            Menge.Text = ViewModel.Menge.ToString();
            Betrag.Text = ViewModel.Betrag.ToString();
            Anmerkung.Text = ViewModel.Anmerkung.ToString();
        }

        public void GetDataFromView()
        {
            ViewModel.Datum = Convert.ToDateTime(Datum.Text);
            ViewModel.Kilometerstand = Convert.ToDouble(Kilometerstand.Text);
            ViewModel.Menge = Convert.ToDouble(Menge.Text);
            ViewModel.Betrag = Convert.ToDouble(Betrag.Text);
            ViewModel.Anmerkung = Anmerkung.Text;
        }
    }
}